<?php

namespace App\Http\Controllers;

use App\KrkmKuliah;
use App\PrklKurSylabus;
use App\PrklMateri;
use App\SysxConfig;
use App\PrklFileMateri;
use App\PrklPraktikum;
use App\PrklFilePraktikum;
use Illuminate\Http\Request;

class PerkuliahanController extends ResponseController
{
    //
    public function filterMatkulByTahunAndProdi($tahun,$prodi){
        $kurikulum = KrkmKuliah::where('id_kur','=',$tahun)->where('ref_kbk_id','=',$prodi)
        ->get([
            'kuliah_id as idKuliah',
            'id_kur as kurikulum',
            'kode_mk as kodeMatakuliah',
            'nama_kul_ind as namaMatakuliahInd',
            'nama_kul_ing as namaMatakuliah Ing',
            'short_name as singkatanMatakuliah',
            'sks',
            'sem',
            'ref_kbk_id as prodiId'
        ]);
        $data  = array();
        for($i = 1; $i < 7; $i++){
            $matkul = array();
            for($j = 0; $j < count($kurikulum); $j++){
                if($i == $kurikulum[$j]->sem){
                    array_push($matkul,$kurikulum[$j]);
                }
            }
            
            $full = array(
                "semester" => $i,
                "matakuliah" => $matkul
            );
            array_push($data,$full);
        }
        return $this->successResponse(200,$data);
    }


    public function getMateriKuliah($idKuliah){
        $sylabus = PrklKurSylabus::where('kuliah_id','=',$idKuliah)->first();
        $config = SysxConfig::where('key','=','tahun_ajaran')->first();
        $tahun_ajaran = $config->value;
        $queryData = request("tahun");
        $ta = $queryData == null ? $tahun_ajaran : $queryData;
        $materiKul = PrklMateri::where('kurikulum_syllabus_id','=', $sylabus->kurikulum_syllabus_id)
        ->where('ta','=',$ta)->orderByRaw('CAST(minggu_ke as SIGNED)','asc')
        ->get([
            'materi_id as materiId',
            'ta as tahunAjaran',
            'id_kur as kurikulum',
            'kode_mk as kodeMatkul',
            'minggu_ke as mingguKe',
            'sesi',
            'judul',
            'isi',
            'tgl_sesi as tanggalSesi',
            'tgl_view as tglView',
            'kurikulum_syllabus_id as kurikulumId'
        ]);
        $data = array();
        for($i = 1 ; $i < 17; $i++){
            $materi = array();
            for($j = 0; $j < count($materiKul); $j++){
                if($i == (int)$materiKul[$j]->mingguKe){
                    array_push($materi,$materiKul[$j]);
                }
            }
            $fullList = array(
                "mingguKe" => $i,
                "materi" => $materi
            );
            array_push($data,$fullList);
        }
        return $this->successResponse(200,$data);
    }
    
    public function getFileMateriKuliah($materiId){
        $file = PrklFileMateri::where('materi_id','=',$materiId)->get([
            'nama_file as namaFile',
            'kode_file as kodeFile',
            'ket as keterangan',
            ]);
            
        return $this->successResponse(200,$file);
    }
    
    public function getPraktikumKuliah($idKuliah){
         $sylabus = PrklKurSylabus::where('kuliah_id','=',$idKuliah)->first();
        $config = SysxConfig::where('key','=','tahun_ajaran')->first();
        $tahun_ajaran = $config->value;
        $queryData = request("tahun");
        $ta = $queryData == null ? $tahun_ajaran : $queryData;
        $materiKul = PrklPraktikum::where('kurikulum_syllabus_id','=', $sylabus->kurikulum_syllabus_id)
        ->where('ta','=',$ta)->orderByRaw('CAST(minggu_ke as SIGNED)','asc')
        ->get([
            'praktikum_id as praktikumId',
            'ta as tahunAjaran',
            'id_kur as kurikulum',
            'kode_mk as kodeMatkul',
            'minggu_ke as mingguKe',
            'sesi',
            'topik',
            'isi',
            'tanggal as tanggalSesi',
            'tgl_view as tglView',
            'kurikulum_syllabus_id as kurikulumId',
            'aktifitas',
            'waktu_pengerjaan as waktuPengerjaan',
            'setoran',
            'batas_akhir as batasAkhir',
            'tempat_penyerahan as tempatPenyerahan',
            'tujuan'
        ]);
        $data = array();
        for($i = 1 ; $i < 17; $i++){
            $materi = array();
            for($j = 0; $j < count($materiKul); $j++){
                if($i == (int)$materiKul[$j]->mingguKe){
                    array_push($materi,$materiKul[$j]);
                }
            }
            $fullList = array(
                "mingguKe" => $i,
                "materi" => $materi
            );
            array_push($data,$fullList);
        }
        return $this->successResponse(200,$data);
    }
    
    public function getFilePraktikumKuliah($praktikumId){
        $file = PrklFilePraktikum::where('praktikum_id','=',$praktikumId)->get([
            'nama_file as namaFile',
            'kode_file as kodeFile',
            'ket as keterangan',
            ]);
            
        return $this->successResponse(200,$file);
    }
}
